﻿//////////////////////////////////////////////
// DdsSurfaceComplexity.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Class ------------------------------------

namespace nkImages::dds
{
	enum class DDS_SURFACE_COMPLEXITY : unsigned int
	{
		DDS_SURFACE_COMPLEXITY_UNKNOWN = 0,
		DDSCAPS_COMPLEX = 0x8,
		DDSCAPS_TEXTURE = 0x1000,
		DDSCAPS_MIPMAP = 0x400000
	} ;

	inline DDS_SURFACE_COMPLEXITY operator& (DDS_SURFACE_COMPLEXITY a, DDS_SURFACE_COMPLEXITY b)
	{
		return (DDS_SURFACE_COMPLEXITY)((unsigned int)a & (unsigned int)b) ;
	}

	inline DDS_SURFACE_COMPLEXITY operator| (DDS_SURFACE_COMPLEXITY a, DDS_SURFACE_COMPLEXITY b)
	{
		return (DDS_SURFACE_COMPLEXITY)((unsigned int)a | (unsigned int)b) ;
	}
}